from re import S
from flask import Flask, request, render_template
import function.function as f
import pandas as pd
from datetime import datetime, timezone, timedelta
app = Flask(__name__)
application = app

@app.route('/')
def my_form():
    return render_template('my-form.html')

@app.route('/', methods=['POST'])
def my_form_post():
    nama = request.form['text']
    waktu = int(request.form['waktu'])
    limit = int(request.form['limit'])    
    #_________________________________________________ BAGI WAKTU (BELUM SELESAI) _________________________________________________
    if waktu <= 7:
        ts = datetime.now(timezone.utc) - timedelta(waktu)
        now = datetime.now(timezone.utc) - timedelta(minutes=1)
        end_time = (now.strftime('%Y-%m-%d')+'T'+now.strftime('%H:%M:%S')+'Z')
        start_time = (ts.strftime('%Y-%m-%d')+'T'+ts.strftime('%H:%M:%S')+'Z')
        dftwitter = f.scrap_twt(limit,nama,start_time,end_time)
    elif waktu > 7:
        return "BELUM BISA LEBIH DARI 7 HARI"    
    import os
    sumber = os.getcwd()
    blaklist = (open(sumber+"\\sumber\\blacklist.txt", "r")).read().split("\n")
    norm = {}
    with open(sumber+"\\sumber\\normalisasi.txt", "r") as file:
        for line in file:
            line = line.replace('\n', '').replace('\r\n', '')
            norm.update({line.split(':')[0]:line.split(':')[1]})        
    
    #___________________________________BLACKLIST KATA
    dataclean = dftwitter
    dftwitterclean = dataclean[~dataclean["text"].str.contains("|".join(blaklist))]    
    #___________________________________MULAI PREPROCESSING DATA
    #standarisasi dan hapus simbol
    dfpakai = dftwitterclean
    dfpakai = dfpakai.drop_duplicates(subset=['text'])
    dfpakai = dfpakai[~dfpakai['text'].isna()]
    dfpakai['text'] = dfpakai['text'].apply(f.clean_twitter_text)
    dfpakai['text'] = dfpakai['text'].str.lower()

    #normalisasi kata
    dfpakai['text'] = dfpakai['text'].apply(lambda x: f.normalisasi(x))

    dfpakai['text_en'] = dfpakai['text'].apply(lambda x: f.translasi_text(x))
    from nltk.tokenize import word_tokenize
    dfpakai['token_en'] = dfpakai['text_en'].apply(lambda x: word_tokenize(x)) 
    dfpakai['filtered_token_en'] = dfpakai['token_en'].apply(lambda x: f.remove_stopwords(x))
    dfpakai['filtered_text_en'] = dfpakai['filtered_token_en'].apply(lambda x: f.stemen(x))
    dfpakai['sentiment_scores'] = dfpakai['filtered_text_en'].apply(lambda x: f.sentimensc(x))
    dfpakai['status'] = ''
    dfpakai.index = range(len(dfpakai))
    for i, j in enumerate(dfpakai['sentiment_scores']):
        if j['compound'] < 0:
            dfpakai.loc[i, 'status'] = 'Negatif'
        elif j['compound'] > 0:
            dfpakai.loc[i, 'status'] = 'Positif'
        else:
            dfpakai.loc[i, 'status'] = 'Netral'
    return dfpakai.to_html()


if __name__ == '__main__':
    app.run(debug=True)